#include <mail/hound/include/internal/wmi/service/subject/rmrefwd.h>
#include <mail/hound/include/internal/wmi/service/subject/subject.h>

namespace {

const char* subject_type(const std::string& sortOps) {
    int rv = 0; // 1 - forward, 2 - reply
    for(std::string::size_type i = 0; i < sortOps.size(); ++i) {
        switch(sortOps[i]) {
        case 'F': rv = 1; break;
        case 'R': rv = 2; i += 2; break;
        }
    }
    switch(rv) {
    case 1: return "forwarded";
    case 2: return "replied";
    default: return "";
    }
}
} // unnamed namespace

SubjectInfo::SubjectInfo(const std::string& subject)
    : m_isSplitted(false)
{
    std::string resStr, encOps, sortOps;
    std::string prefix, result, postfix;
    stripReFwd(subject, resStr, sortOps, encOps, false);
    if (!reconstrPartsReFwd(resStr, prefix, result, postfix, encOps)) {
        if(!prefix.empty()) {
            m_type=subject_type(sortOps);
            m_prefix=prefix;
        }
        m_subject=result;
        m_postfix=postfix;
        m_isSplitted=true;
    } else {
        m_subject=subject;
    }
}
