#include <mail/hound/include/internal/v2/archive_status/reflection.h>
#include <mail/hound/include/internal/v2/archive_status/v1_adaptor.h>

#include <yamail/data/serialization/json_writer.h>

namespace hound::server::handlers::v2::archive_status {

void Handler::execute(RequestPtr r, boost::asio::yield_context yield) const {
    auto& request = *r;
    try {
        const auto metadata = getMetadata(request);
        executeMacs(r, metadata, yield);
    } catch (const macs::ParamsException&) {
        request.responseBadRequestException();
    } catch (const boost::system::system_error& e) {
        if (e.code() == sharpei::client::Errors::UidNotFound || e.code() == sharpei::client::Errors::HttpCode) {
            request.responseBadRequestException();
        } else {
            request.responseInternalErrorException();
        }
    } catch (...) {
        request.responseInternalErrorException();
    }
}

void Handler::executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yield) const {
    auto h = macs::io::make_yield_context(yield);
    const auto& userRepo = metadata->users();

    const auto freezingInfo = userRepo.getFreezingInfo(h);
    const auto user_state = freezingInfo.state;
    hound::archive::StatusResult res{.user_state=user_state};
    if (macs::UserState::archived == user_state || macs::UserState::active == user_state) {
        const auto archive = userRepo.getArchive(h);
        
        if (archive) {
            res.archive_state = archive->state;
            res.message_count = archive->message_count;
            res.restored_message_count = archive->restored_message_count;
        }
    }

    request->response(res);
}

}  // namespace hound::server::handlers::v2::archive_status
