#include <mail/hound/include/internal/v2/attach_sid/method.h>
#include <mail/hound/include/internal/v2/attach_sid/v1_adaptor.h>
#include <mail/hound/include/internal/wmi/yplatform/filter_arguments.h>


namespace hound::server::handlers::v2::attach_sid {

void Handler::execute(RequestPtr r, boost::asio::yield_context /*yield*/) const {
    Request& req = *r;

    const macs::Uid uid = req.getArg("uid");
    const macs::Mid mid = req.getArg("mid");

    std::vector<std::string> hids;
    req.getArgList("hids", std::back_inserter(hids));
    filterEmptyItems(hids, req.logger, "hids", req.method.c_str());

    constexpr std::chrono::days timeout(3);
    const mail_getter::attach_sid::Packer attachShield(timeout, config().keys());

    const v2::attach_sid::Request in{uid, mid, hids};
    const auto out = v2::attach_sid::Method<decltype(attachShield)>{attachShield}(in);

    if (!out) {
        return req.responseBadRequest(out.error());
    }
    return req.response(out.value());
}

}
