#include <mail/hound/include/internal/v2/changelog/mailbox.h>
#include <mail/hound/include/internal/v2/changelog/method.h>
#include <mail/hound/include/internal/v2/changelog/v1_adaptor.h>

namespace hound::server::handlers::v2::changelog {

using namespace hound::v2::changelog;

void Handler::executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const {
    auto yield = macs::io::make_yield_context(yieldCtx);
    try {
        v2::changelog::Request in;
        in.uid = request->getArg("uid");

        using boost::conversion::try_lexical_convert;

        macs::Revision::Value revision;
        if (!try_lexical_convert(request->getArg("revision"), revision)) {
            request->responseBadRequest(libwmi::error::invalidArgument, "invalid revision argument");
            return;
        }
        in.revision = revision;

        if (!try_lexical_convert(request->getArg("max_count"), in.max_count)) {
            request->responseBadRequest(libwmi::error::invalidArgument, "invalid max_count argument");
            return;
        }

        std::vector<std::string> changeTypeNames;

        request->getArgList("changelog_types", std::back_inserter(changeTypeNames));

        std::string checkRevisionPolicy = request->getOptionalArg("check_revision_policy").get_value_or(
                    "loyal");
        in.check_revision_policy = CheckRevisionPolicy::fromString(checkRevisionPolicy, std::nothrow);
        if (in.check_revision_policy == CheckRevisionPolicy::unknown) {
            request->responseBadRequest(libwmi::error::invalidArgument, "invalid check_revision_policy argument");
            return;
        }

        auto[types, badInputs] = ::hound::v2::changes::changeTypesFromStrings(changeTypeNames);
                if (!badInputs.empty()) {
            request->responseBadRequest(
                libwmi::error::invalidArgument,
                "invalid changelog type(s): '" + boost::algorithm::join(badInputs, "', '") + "'"
            );
            return;
        }
        in.change_types = std::move(types);

        auto getMailbox = [&metadata, &yield](auto &) {
            return Mailbox{metadata.get(), yield};
        };
        const auto out = v2::changelog::Method<decltype(getMailbox)>{std::move(getMailbox)}(in);

        if (!out) {
            request->responseBadRequest(out.error());
            return;
        }
        using namespace yamail::data::reflection;
        using namespace yamail::data::serialization;
        request->response(out.value(), options(yajl::optForceNull));
    } catch (const boost::system::system_error &e) {
        if (sharpei::client::Errors::UidNotFound == e.code() || sharpei::client::Errors::HttpCode == e.code()) {
            request->responseBadRequestException();
        } else {
            request->responseInternalErrorException();
        }
    } catch (...) {
        request->responseInternalErrorException();
    }
}

} // namespace hound::server::handlers::v2::changelog
