#include <mail/hound/include/internal/v2/changes/mailbox.h>
#include <mail/hound/include/internal/v2/changes/method.h>
#include <mail/hound/include/internal/v2/changes/v1_adaptor.h>

#include <boost/lexical_cast.hpp>

namespace hound::server::handlers::v2::changes {

using namespace hound::v2::changes;

void Handler::executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const {
    auto yield = macs::io::make_yield_context(yieldCtx);
    try {
        v2::changes::Request in;
        in.uid = request->getArg("uid");

        using boost::conversion::try_lexical_convert;

        macs::Revision::Value revision;
        if (!try_lexical_convert(request->getArg("revision"), revision)) {
            request->responseBadRequest(libwmi::error::invalidArgument, "invalid revision argument");
            return;
        }
        in.revision = revision;

        if (!try_lexical_convert(request->getArg("max_count"), in.max_count)) {
            request->responseBadRequest(libwmi::error::invalidArgument, "invalid max_count argument");
            return;
        }

        auto getMailbox = [&](auto &) {
            return Mailbox{metadata.get(), yield};
        };
        const auto out = v2::changes::Method<decltype(getMailbox)>{std::move(getMailbox)}(in);

        if (!out) {
            request->responseBadRequest(out.error());
            return;
        }
        using namespace yamail::data::reflection;
        using namespace yamail::data::serialization;
        request->response(out.value(), options(yajl::optForceNull));
    } catch (const boost::system::system_error &e) {
        if (sharpei::client::Errors::UidNotFound == e.code() || sharpei::client::Errors::HttpCode == e.code()) {
            request->responseBadRequestException();
        } else {
            request->responseInternalErrorException();
        }
    } catch (...) {
        request->responseInternalErrorException();
    }
}

} // namespace hound::server::handlers::v2::changes
