#include <mail/hound/include/internal/v2/first_envelope_date/v1_adaptor.h>

namespace hound::server::handlers::v2::first_envelope_date {

void Handler::execute(RequestPtr r, boost::asio::yield_context yield) const {
    Request& request = *r;
    try {
        const MailMetadataPtr metadata(getMetadata(request));
        executeMacs(r, metadata, yield);
    } catch (const macs::ParamsException&) {
        request.responseBadRequestException();
    } catch (const boost::system::system_error &e) {
        if (sharpei::client::Errors::UidNotFound == e.code() || sharpei::client::Errors::HttpCode == e.code()) {
            request.responseBadRequestException();
        } else {
            request.responseInternalErrorException();
        }
    } catch (...) {
        request.responseInternalErrorException();
    }
}

void Handler::executeMacs(RequestPtr request, const MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const {
    auto yield = macs::io::make_yield_context(yieldCtx);
    const auto fid = request->getArg("fid");

    if (fid.empty()) {
        request->responseBadRequest(libwmi::error::invalidArgument, "fid is missing or empty");
        return;
    }

    const auto date = metadata->envelopes().getFirstEnvelopeDateOptional(fid, yield);
    request->response(date, "first_envelope_date");
}

}
