#include <mail/hound/include/internal/v2/first_envelope_date_in_tab/v1_adaptor.h>

namespace hound::server::handlers::v2::first_envelope_date_in_tab {

void Handler::execute(RequestPtr r, boost::asio::yield_context yield) const {
    Request& request = *r;
    try {
        const MailMetadataPtr metadata(getMetadata(request));
        executeMacs(r, metadata, yield);
    } catch (const macs::ParamsException&) {
        request.responseBadRequestException();
    } catch (const boost::system::system_error &e) {
        if (sharpei::client::Errors::UidNotFound == e.code() || sharpei::client::Errors::HttpCode == e.code()) {
            request.responseBadRequestException();
        } else {
            request.responseInternalErrorException();
        }
    } catch (...) {
        request.responseInternalErrorException();
    }
}

void Handler::executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const {
    auto yield = macs::io::make_yield_context(yieldCtx);
    const std::string tab = request->getArg("tab");

    if (tab.empty()) {
        request->responseBadRequest(libwmi::error::invalidArgument, "tab is missing or empty");
        return;
    }

    const macs::Tab::Type tabType = macs::Tab::Type::fromString(tab, std::nothrow);
    if (tabType == macs::Tab::Type::unknown) {
        request->responseBadRequest(libwmi::error::invalidArgument, "invalid tab argument");
        return;
    }

    const auto date = metadata->envelopes().getFirstEnvelopeDateInTab(tabType, yield);
    request->response(date, "first_envelope_date_in_tab");
}

}
