#include <mail/hound/include/internal/v2/folders_tree/mailbox.h>
#include <mail/hound/include/internal/v2/folders_tree/method.h>
#include <mail/hound/include/internal/v2/folders_tree/v1_adaptor.h>

namespace hound::server::handlers::v2::folders_tree {

void Handler::executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const {
    auto yield = macs::io::make_yield_context(yieldCtx);
    try {
        v2::folders_tree::Request in;
        in.uid = request->getArg("uid");
        in.sort = request->getArg("sort");
        in.lang = request->getOptionalArg("lang");

        auto getMailbox = [&](auto &) {
            return Mailbox{metadata.get(), yield};
        };
        const auto out = v2::folders_tree::Method<decltype(getMailbox)>{std::move(getMailbox)}(in);

        if (!out) {
            request->responseBadRequest(out.error());
            return;
        }
        request->response(out.value());
    } catch (const boost::system::system_error &e) {
        if (sharpei::client::Errors::UidNotFound == e.code() || sharpei::client::Errors::HttpCode == e.code()) {
            request->responseBadRequestException();
        } else {
            request->responseInternalErrorException();
        }
    } catch (...) {
        request->responseInternalErrorException();
    }
}

} // namespace hound::server::handlers::v2::folders_tree
