#include <mail/hound/include/internal/v2/freezing_info/reflection.h>
#include <mail/hound/include/internal/v2/freezing_info/v1_adaptor.h>

#include <yamail/data/serialization/json_writer.h>

namespace hound::server::handlers::v2::freezing_info {

void Handler::execute(RequestPtr r, boost::asio::yield_context yield) const {
    auto& request = *r;
    try {
        const auto metadata = getMetadata(request);
        executeMacs(r, metadata, yield);
    } catch (const macs::ParamsException&) {
        request.responseBadRequestException();
    } catch (const boost::system::system_error& e) {
        if (e.code() == sharpei::client::Errors::UidNotFound || e.code() == sharpei::client::Errors::HttpCode) {
            request.responseBadRequestException();
        } else {
            request.responseInternalErrorException();
        }
    } catch (...) {
        request.responseInternalErrorException();
    }
}

void Handler::executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yield) const {
    auto h = macs::io::make_yield_context(yield);
    macs::FreezingInfo info = metadata->users().getFreezingInfo(h);
    request->response(info);
}

}  // namespace hound::server::handlers::v2::freezing_info
