#include <mail/hound/include/internal/v2/from_favorite_user_counter/mailbox.h>
#include <mail/hound/include/internal/v2/from_favorite_user_counter/method.h>
#include <mail/hound/include/internal/v2/from_favorite_user_counter/v1_adaptor.h>

namespace hound::server::handlers::v2::from_favorite_user_counter {

void Handler::executeMacs(
        RequestPtr request
        , MailMetadataPtr metadata
        , boost::asio::yield_context yieldCtx
) const {
    auto yield = macs::io::make_yield_context(yieldCtx);
    using boost::conversion::try_lexical_convert;

    const auto getLimit = [&](const std::string &argName, size_t limit)
            -> yamail::expected<size_t> {
        const auto argOpt = request->getOptionalArg(argName);
        if (argOpt) {
            size_t value;
            if (!try_lexical_convert(*argOpt, value)) {
                return yamail::make_unexpected(error_code{error::invalidArgument, "invalid " + argName + " argument"});
            }
            if (value > limit) {
                return yamail::make_unexpected(error_code{error::invalidArgument, argName + " can't be more than " + std::to_string(limit)});
            }
            return value;
        }
        return limit;
    };

    try {
        v2::from_favorite_user_counter::Request in;
        in.uid = request->getArg("uid");

        const auto counterLimitVariant = getLimit("counter_limit", config().countersLimit());
        if (!counterLimitVariant) {
            request->responseBadRequest(counterLimitVariant.error());
            return;
        }
        in.counterLimit = counterLimitVariant.value();

        const auto mailboxLimitVariant = getLimit("mailbox_limit", config().mailboxLimit());
        if (!mailboxLimitVariant) {
            request->responseBadRequest(mailboxLimitVariant.error());
            return;
        }
        in.mailboxLimit = mailboxLimitVariant.value();

        auto getMailbox = [&](auto &) {
            return Mailbox{metadata.get(), yield};
        };

        const auto out = v2::from_favorite_user_counter::Method<decltype(getMailbox)>{std::move(getMailbox)}(in);

        if (!out) {
            request->responseBadRequest(out.error());
            return;
        }
        request->response(out.value());
    } catch (const boost::system::system_error &e) {
        if (sharpei::client::Errors::UidNotFound == e.code() || sharpei::client::Errors::HttpCode == e.code()) {
            request->responseBadRequestException();
        } else {
            request->responseInternalErrorException();
        }
    } catch (...) {
        request->responseInternalErrorException();
    }
}

} // namespace hound::server::handlers::v2::from_favorite_user_counter
