#include <mail/hound/include/internal/v2/mids_by_tids_and_lids/mailbox.h>
#include <mail/hound/include/internal/v2/mids_by_tids_and_lids/method.h>
#include <mail/hound/include/internal/v2/mids_by_tids_and_lids/v1_adaptor.h>

namespace hound::server::handlers::v2::mids_by_tidsandlids {

void Handler::executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const {
    auto yield = macs::io::make_yield_context(yieldCtx);
    try {
        const auto getMailbox([&metadata, &yield] {
            return Mailbox{metadata.get(), yield};
        });

        macs::Tids tids;
        std::string name("tid");
        request->getArgList(name, std::back_inserter(tids));

        macs::Lids lids;
        name = "lid";
        request->getArgList(name, std::back_inserter(lids));

        const auto result(Method<decltype(getMailbox)>{std::move(getMailbox)}({std::move(tids), std::move(
                                                                               lids)}, config().tidsLimit()));

        if (!result) {
            request->responseBadRequest(result.error());
            return;
        }

        request->response(result.value());
    } catch (const boost::system::system_error &ex) {
        if ((ex.code() == sharpei::client::Errors::UidNotFound) ||
            (ex.code() == sharpei::client::Errors::HttpCode)) {
            request->responseBadRequestException();
        } else {
            request->responseInternalErrorException();
        }
    } catch (...) {
        request->responseInternalErrorException();
    }
}

} // namespace hound::server::handlers::v2::mids_by_tidsandlids
