#include <mail/hound/include/internal/v2/reset_tab_unvisited/mailbox.h>
#include <mail/hound/include/internal/v2/reset_tab_unvisited/v1_adaptor.h>

namespace hound::server::handlers::v2::reset_tab_unvisited {

void Handler::executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const {
    auto yield = macs::io::make_yield_context(yieldCtx);
    try {
        Params params;
        Mailbox mailbox{metadata.get(), yield};
        QueryParams queryParams;

        if (auto ec = queryParams.getParams(params, *request, mailbox)) {
            request->responseBadRequest(ec);
            return;
        }

        mailbox.resetFresh(std::move(params.tab));
        request->responseEmptyJson();
    } catch (const boost::system::system_error &e) {
        if (sharpei::client::Errors::UidNotFound == e.code() || sharpei::client::Errors::HttpCode == e.code()) {
            request->responseBadRequestException();
        } else {
            request->responseInternalErrorException();
        }
    } catch (...) {
        request->responseInternalErrorException();
    }
}

} // namespace hound::server::handlers::v2::reset_tab_unvisited
