#include <mail/hound/include/internal/v2/stickers/v1_adaptor.h>
#include <macs/types.h>
#include <macs/sticker.h>
#include <yamail/data/reflection/reflection.h>


YREFLECTION_ADAPT_ADT(macs::ReplyLaterSticker,
    YREFLECTION_MEMBER(macs::Mid, mid)
    YREFLECTION_MEMBER(macs::StickerType, type)
    YREFLECTION_MEMBER(macs::Fid, fid)
    YREFLECTION_MEMBER(macs::Tid, tid)
    (tab, obj.tab ? obj.tab.value().toString() : "", yamail::data::reflection::readOnly(obj, val))
    YREFLECTION_MEMBER(std::time_t, date)
    YREFLECTION_MEMBER(std::time_t, created)
)


namespace hound::server::handlers::v2::stickers {

template <typename Stickers>
struct Response {
    Stickers stickers;
};

}

BOOST_FUSION_ADAPT_TPL_STRUCT((Stickers), (hound::server::handlers::v2::stickers::Response) (Stickers),
    (Stickers, stickers)
)

namespace hound::server::handlers::v2::stickers {

void Handler::execute(RequestPtr r, boost::asio::yield_context yield) const {
    Request& request = *r;
    try {
        MailMetadataPtr metadata(getMetadata(request));
        executeMacs(r, metadata, yield);
    } catch (const macs::ParamsException&) {
        request.responseBadRequestException();
    } catch (...) {
        request.responseInternalErrorException();
    }
}

void Handler::executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const {
    auto yield = macs::io::make_yield_context(yieldCtx);
    try {
        using yamail::data::reflection::from_string;

        macs::StickerType type;
        if (!from_string<macs::StickerType>(request->getArg("type"), type)) {
            request->responseBadRequest(libwmi::error::invalidArgument, "invalid type argument");
            return;
        }

        if (type == macs::StickerType::reply_later) {
            Response<macs::ReplyLaterStickers> stickers {
                .stickers = metadata->stickers().getReplyLaterList(yield)
            };
            request->response(stickers);
        }

    } catch (const boost::system::system_error &e) {
        if (sharpei::client::Errors::UidNotFound == e.code() || sharpei::client::Errors::HttpCode == e.code()) {
            request->responseBadRequestException();
        } else {
            request->responseInternalErrorException();
        }
    } catch (...) {
        request->responseInternalErrorException();
    }
}

}
