#include <mail/hound/include/internal/v2/unfreeze_user/v1_adaptor.h>
#include <mail/hound/include/internal/wmi/service/passport.h>
#include <mail/hound/include/internal/user_state.h>

#include <yamail/data/serialization/json_writer.h>

#include <boost/lexical_cast.hpp>
#include <yplatform/find.h>
#include <mail/http_getter/client/include/module.h>
#include <mail/logdog/include/logdog/logger.h>


namespace hound::server::handlers::v2::unfreeze_user {

void Handler::execute(RequestPtr r, boost::asio::yield_context yield) const {
    auto& request = *r;
    try {
        const auto metadata = getMetadata(request);
        executeMacs(r, metadata, yield);
    } catch (const macs::ParamsException&) {
        request.responseBadRequestException();
    } catch (const boost::system::system_error& e) {
        if (e.code() == sharpei::client::Errors::UidNotFound || e.code() == sharpei::client::Errors::HttpCode) {
            request.responseBadRequestException();
        } else {
            request.responseInternalErrorException();
        }
    } catch (...) {
        request.responseInternalErrorException();
    }
}

void Handler::executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yield) const {
    auto h = macs::io::make_yield_context(yield);
    macs::FreezingInfo info = metadata->users().getFreezingInfo(h);
    if (info.state != macs::UserState::frozen) {
        throw macs::ParamsException("User is not frozen");
    }

    const std::string uid = request->getArg("uid");
    const std::string requestId = request->requestId();

    const auto httpClient = config().httpClient()->create(*(request->request), nullptr);
    PassportResponse passportResponse = passportUnfreeze(httpClient, config().passportEndpoint(), uid, yield);
    if (!passportResponse.hasError()) {
        metadata->users().unfreezeUser(h);
        internal::logUserStateChange(boost::lexical_cast<uint64_t>(uid), requestId, "frozen", "active", info.notifiesCount);
        request->responseEmptyJson();
    } else {
        if (passportResponse.hasOnlyRetriableErrors()) {
            request->responseInternalError(
                libwmi::error::internal,
                "retriable error from passport: " + yamail::data::serialization::toJson(passportResponse).str()
            );
        } else {
            request->responseBadRequest(
                libwmi::error::invalidArgument,
                "not retriable error from passport: " + yamail::data::serialization::toJson(passportResponse).str()
            );
        }
    }
}

}  // namespace hound::server::handlers::v2::unfreeze_user
