#include <mail/hound/include/internal/v2/yamail_status/mailbox.h>
#include <mail/hound/include/internal/v2/yamail_status/method.h>
#include <mail/hound/include/internal/v2/yamail_status/v1_adaptor.h>

namespace hound::server::handlers::v2::yamail_status {

void Handler::executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const {
    auto yield = macs::io::make_yield_context(yieldCtx);
    try {
        v2::yamail_status::Request in;
        in.uid = request->getArg("uid");

        auto getMailbox = [&](auto &) {
            return Mailbox{metadata.get(), yield};
        };
        const auto out = v2::yamail_status::Method<decltype(getMailbox)>{std::move(getMailbox)}(in);

        if (!out) {
            request->responseBadRequest(out.error());
            return;
        }
        request->response(out.value());
    } catch (const boost::system::system_error &e) {
        if (sharpei::client::Errors::UidNotFound == e.code() || sharpei::client::Errors::HttpCode == e.code()) {
            request->responseBadRequestException();
        } else {
            request->responseInternalErrorException();
        }
    } catch (...) {
        request->responseInternalErrorException();
    }
}

}  // namespace hound::server::handlers::v2::yamail_status
