#include <mail/hound/include/internal/server/handlers/messages_unread_useful.h>

namespace hound::server::handlers {

void MessagesUnreadUsefulHandler::executeMacs(RequestPtr request, macs::ServicePtr metadata, boost::asio::yield_context yieldCtx) const {
    auto yield = macs::io::make_yield_context(yieldCtx);
    const auto &rcptDesc = macs::EnvelopesSorting(macs::SortingType_descending);
    const macs::Label seen = metadata->labels().getAllLabels(yield)
            .at(macs::Label::Symbol::seen_label);

    const macs::FolderSet folderSet = metadata->folders().getAllFolders(yield);
    const auto &fids = hound::helpers::getUnreadUsefulFolders(folderSet);

    const auto &countStr = request->getArg("count");
    std::size_t count = 0;
    if (!countStr.empty()) try {
        count = boost::lexical_cast<std::size_t>(countStr);
    } catch (const boost::bad_lexical_cast &) {}
    if (!count) {
        count = config().itemsPerPage();
    }

    std::vector<helpers::Envelope> envelopes;
    if (!fids.empty()) {
        const auto result = metadata->envelopes().query()
                .inFolders(std::move(fids))
                .count(count)
                .sortBy(rcptDesc)
                .withoutLabel(seen)
                .get(yield);
        envelopes = std::vector<helpers::Envelope>{std::begin(result), std::end(result)};
    }
    request->response(envelopes, "envelopes");
}

}
