#include <mail/hound/include/internal/server/handlers/mimes.h>
#include <mail/hound/include/internal/wmi/yplatform/reflection/mimes.h>
#include <mail/hound/include/internal/wmi/yplatform/helpers/mimes_helpers.h>
#include <mail/hound/include/internal/wmi/service/mulcagate/logging.h>
#include <mail/hound/include/internal/wmi/yplatform/helpers/email.h>

namespace hound::server::handlers {

using namespace hound::helpers::mimes;

void Mimes::fillMetaPartsFromXml(macs::MidsWithMimes& mimes,
        mail_getter::MetaPartsConverterPtr converter, boost::optional<boost::asio::yield_context> yield) {
    for (auto& midStidMime: mimes) {
        macs::MimeParts& mimeParts = std::get<2>(midStidMime);
        if (mimeParts.empty()) {
            const macs::Stid& stid = std::get<1>(midStidMime);
            const auto metaParts = converter->getMetaPartsFromXml(stid, yield);
            boost::copy(metaParts | boost::adaptors::map_values, std::back_inserter(mimeParts));
        }
    }
}

void Mimes::fillMetaPartsForInline(macs::MidsWithMimes& mimes, mail_getter::ServicePtr storageService,
        mail_getter::MetaPartsConverterPtr converter, boost::optional<boost::asio::yield_context> yield) {
    for (auto& midStidMime: mimes) {
        const macs::Stid& stid = std::get<1>(midStidMime);
        macs::MimeParts& mimeParts = std::get<2>(midStidMime);

        const auto messageAccess = storageService->createMessageAccess(
                mail_getter::getMessageAccessParams(stid, mimeParts), helpers::recognizer(), yield);

        const auto inlineMimeParts = extractInlineParts(messageAccess, mimeParts, converter, yield);
        mimeParts.insert(mimeParts.end(), inlineMimeParts.begin(), inlineMimeParts.end());
    }
}

void Mimes::executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yield) const {
    macs::Mids mids;
    request->getArgList("mid", std::back_inserter(mids));
    const bool withMulca = request->getBoolArg("with_mulca");
    const bool withInline = request->getBoolArg("with_inline");

    const auto mgLogger = MulcagateLog::create(request->logger);
    const auto storageService = config().mailStorage()->createService(mgLogger, tvm::Ticket(),
        request->requestId());
    const auto converter = storageService->createMetaPartsConverter(helpers::recognizer());

    macs::MidsWithMimes windatMimes = metadata->envelopes().getWindatMimes(mids, macs::io::make_yield_context(yield));
    macs::MidsWithMimes mimes = metadata->envelopes().getMimes(mids, macs::io::make_yield_context(yield));

    if (withMulca) {
        fillMetaPartsFromXml(mimes, converter, yield);
    }

    if (withInline) {
        fillMetaPartsForInline(mimes, storageService, converter, yield);
    }

    request->response(makeMimes(std::move(mimes), std::move(windatMimes)), "mimes");
}

}
