#include <boost/range/algorithm/transform.hpp>
#include <mail/hound/include/internal/wmi/yplatform/helpers/detailed_envelopes.h>

namespace hound::helpers {

detailed_envelopes::Result detailedEnvelopes(std::vector<helpers::Envelope> envelopes,
                                             const macs::FolderSet& folders,
                                             const macs::LabelSet& labels) {
    using namespace detailed_envelopes;

    LidsMids missingLids;
    FidsMids missingFids;

    const auto detailedEnvelope = [&] (Envelope&& envelope) {
        const auto toLabels = [&] (const std::vector<std::string>& lids) {
            helpers::LabelsMap result;
            for (const auto& lid : lids) {
                const auto it = labels.find(lid);
                if (it == labels.end()) {
                    missingLids[lid].push_back(envelope.mid());
                } else {
                    result.insert(*it);
                }
            }
            return result;
        };

        const auto it = folders.find(envelope.fid());
        if (it == folders.end()) {
            missingFids[envelope.fid()].push_back(envelope.mid());
            auto labels = toLabels(envelope.labels());
            return helpers::DetailedEnvelope(std::move(envelope), std::move(labels));
        } else {
            const auto& folder = it->second;
            auto labels = toLabels(envelope.labels());
            return helpers::DetailedEnvelope(std::move(envelope), FolderWithPath{folder, folders.getPath(folder)},
                                             std::move(labels));
        }
    };

    std::vector<DetailedEnvelope> result;
    for(auto& e : envelopes) {
        result.push_back(detailedEnvelope(std::move(e)));
    }
    return Result {std::move(result), std::move(missingLids), std::move(missingFids)};
}

}
