#include <butil/StrUtils/StrUtils.h>
#include <butil/network/rfc2822.h>
#include <butil/network/idn.h>

#include <mimeparser/rfc2047.h>
#include <mimeparser/ccnv.h>

#include <mail_getter/UTFizer.h>

#include <mail/hound/include/internal/wmi/yplatform/helpers/email.h>

namespace hound::helpers {

const Recognizer::Wrapper& recognizer(const std::string& languageDict, const std::string& languageWeights,
                                      const std::string& encodingDict) {
    static auto instance = Recognizer::create(languageDict.c_str(), languageWeights.c_str(), encodingDict.c_str());
    return *instance;
}

std::string normalizeName(const std::string& name) {
    std::string charset;
    std::string res = mulca_mime::decode_rfc2047(name, charset);
    try {
        utfizeString(recognizer(), res, charset);
    } catch(const UTFizerException&) {}
    res = TStrUtils::removeSurroundQuotes(TStrUtils::unescape(res));
    return res;
}

Email toEmail(const rfc2822ns::address_iterator& addr) {
    Email res;
    res.domain = idna::decode(addr.domain());
    res.local = normalizeName(addr.local());

    details::setDisplayName(res, addr.display(), normalizeName);
    return res;
}

Emails toEmails(const std::string& emails) {
    Emails res;
    const std::string goodStr =
            TStrUtils::removeBadSymbols(mulca_mime::decode_numbered_entities(emails));

    try {
        for (rfc2822ns::address_iterator iter(goodStr), end; iter != end; ++iter) {
            res.push_back(toEmail(iter));
        }
    } catch (const rfc2822ns::invalid_address&) { }
    return res;
}

Email convertEmail(const ::Email& email) {
    Email res;
    if (email.local().empty() && email.domain().empty()) {
        res.displayName = email.displayName();
    } else {
        res.local = email.local();
        res.domain = idna::decode(email.domain());
        details::setDisplayName(res, email.displayName(), normalizeName);
    }
    return res;
}

}
