#include <mail/hound/include/internal/wmi/yplatform/helpers/mimes_helpers.h>
#include <boost/algorithm/string.hpp>
#include <boost/range/algorithm/copy.hpp>
#include <boost/range/adaptors.hpp>
#include <mail_getter/MessageAccess.h>

namespace hound::helpers::mimes {

bool isInlinePart(const macs::MimePart& mimePart) {
    return mimePart.contentType() == "message" && mimePart.contentSubtype() == "rfc822";
}

bool existChildrenMimeParts(const macs::MimeParts& mimeParts, const macs::Hid& hid) {
    for (const auto& mimePart: mimeParts) {
        if (boost::starts_with(mimePart.hid(), hid + ".")) {
            return true;
        }
    }
    return false;
}

macs::MimeParts extractInlineParts(MessageAccessPtr messageAccess, const macs::MimeParts& mimeParts,
        mail_getter::MetaPartsConverterPtr converter, OptYieldContext yield) {
    macs::MimeParts inlineMimeParts;
    for (const auto& mimePart: mimeParts) {
        if (isInlinePart(mimePart) && !existChildrenMimeParts(mimeParts, mimePart.hid())) {
            const auto metaParts = converter->extractMetaPartsFromInline(messageAccess, mimePart, yield);
            boost::copy(metaParts | boost::adaptors::map_values, std::back_inserter(inlineMimeParts));
        }
    }
    return inlineMimeParts;
}

}
