#include <mail/hound/include/internal/wmi/yplatform/reflection/mimes.h>
#include <mail/hound/include/internal/wmi/windat.h>
#include <boost/range/adaptor/transformed.hpp>

namespace hound {

Mimes makeMimes(macs::MidsWithMimes midStidMimeParts, macs::MidsWithMimes windatMidStidMimeParts) {
    using boost::adaptors::transformed;
    using Map = StidHidMimeParts;
    Mimes result;
    for (auto &v : midStidMimeParts) {
        macs::Mid mid;
        macs::Stid stid;
        macs::MimeParts mimeParts;
        std::tie(mid, stid, mimeParts) = std::move(v);
        auto messageParts = mimeParts
            | transformed([&] (auto& v) {
                auto hid = v.hid();
                return std::make_pair(std::move(hid), std::move(v));
            });
        result[std::move(mid)].root = RootMessagePart {std::move(stid), Map(messageParts.begin(), messageParts.end())};
    }
    for (auto &v : windatMidStidMimeParts) {
        macs::Mid mid;
        macs::Stid stid;
        macs::MimeParts mimeParts;
        std::tie(mid, stid, mimeParts) = std::move(v);
        auto messageParts = mimeParts
            | transformed([&] (auto& v) {
                auto hid = v.hid();
                return std::make_pair(std::move(hid), StidHidMessagePart {windatMulcaHid, std::move(v)});
            });
        result[std::move(mid)].other[std::move(stid)].insert(messageParts.begin(), messageParts.end());
    }
    return result;
}

} // namespace hound
