#pragma once

#include <mail/unistat/cpp/include/common_logs.h>
#include "hound_meters.h"

namespace unistat {

using HoundLogMeters = std::variant<std::shared_ptr<CountErrors>, std::shared_ptr<XdbErrorsTop>,
        std::shared_ptr<PggFallbackMeter>, std::shared_ptr<EmptyResultFilterSearch>,
        std::shared_ptr<CountWmiErrors>>;
using HoundLog = Log<TextFileReader, File, TskvParser, HoundLogMeters>;
using HoundLogPtr = std::shared_ptr<HoundLog>;

using Logs = std::variant<AccessTskvPtr, HoundLogPtr, HttpClientLogPtr, PaLogPtr, SupervisorLogPtr>;

} // namespace unistat
