from cpython cimport *
from libcpp.vector cimport vector
from libcpp.memory cimport shared_ptr

cimport mail.unistat.cpp.cython.run_cpp
from mail.unistat.cpp.cython.logs cimport *
from mail.unistat.cpp.cython.meters cimport *

cimport hound_logs_cpp
cimport hound_meters_cpp


cdef class XdbErrorsTop:
    cdef shared_ptr[hound_meters_cpp.XdbErrorsTop] __impl
    def __cinit__(self, topNumber, bytes name):
        self.__impl.reset(new hound_meters_cpp.XdbErrorsTop(<size_t>topNumber, <const char*>name))


cdef class PggFallbackMeter:
    cdef shared_ptr[hound_meters_cpp.PggFallbackMeter] __impl
    def __cinit__(self, bytes name):
        self.__impl.reset(new hound_meters_cpp.PggFallbackMeter(<const char*>name))


cdef class EmptyResultFilterSearch:
    cdef shared_ptr[hound_meters_cpp.EmptyResultFilterSearch] __impl
    def __cinit__(self, bytes name):
        self.__impl.reset(new hound_meters_cpp.EmptyResultFilterSearch(<const char*>name))


cdef class CountWmiErrors:
    cdef shared_ptr[hound_meters_cpp.CountWmiErrors] __impl
    def __cinit__(self, vector[int] expectedErrors, bytes name):
        self.__impl.reset(new hound_meters_cpp.CountWmiErrors(expectedErrors, <const char*>name))


cdef class HoundLog:
    cdef shared_ptr[hound_logs_cpp.HoundLog] __impl

    def __cinit__(self, pyMeters, cppMeters, bint fastForward, bytes path):
        cdef vector[PyObject *] pm
        for m in pyMeters:
            pm.push_back(<PyObject *>m)
        cdef vector[hound_logs_cpp.HoundLogMeters] cm
        for m in cppMeters:
            if isinstance(m, CountErrors):
                cm.push_back(hound_logs_cpp.HoundLogMeters((<CountErrors>m).__impl))
            elif isinstance(m, XdbErrorsTop):
                cm.push_back(hound_logs_cpp.HoundLogMeters((<XdbErrorsTop>m).__impl))
            elif isinstance(m, PggFallbackMeter):
                cm.push_back(hound_logs_cpp.HoundLogMeters((<PggFallbackMeter>m).__impl))
            elif isinstance(m, EmptyResultFilterSearch):
                cm.push_back(hound_logs_cpp.HoundLogMeters((<EmptyResultFilterSearch>m).__impl))
            elif isinstance(m, CountWmiErrors):
                cm.push_back(hound_logs_cpp.HoundLogMeters((<CountWmiErrors>m).__impl))
            else:
                raise AttributeError("Unknown meter type for HoundLog")
        self.__impl.reset(new hound_logs_cpp.HoundLog(pm, cm, fastForward, <const char*>path))


def run(host, port, pyLogs, yplatformLogPath, logLevel):
    cdef vector[logs_cpp.Logs] cppLogs
    for l in pyLogs:
        if isinstance(l, AccessTskv):
            cppLogs.push_back(
                logs_cpp.Logs((<AccessTskv>l).__impl)
            )
        elif isinstance(l, HoundLog):
            cppLogs.push_back(
                logs_cpp.Logs((<HoundLog>l).__impl)
            )
        elif isinstance(l, HttpClientLog):
            cppLogs.push_back(
                logs_cpp.Logs((<HttpClientLog>l).__impl)
            )
        elif isinstance(l, PaLog):
            cppLogs.push_back(
                logs_cpp.Logs((<PaLog>l).__impl)
            )
        elif isinstance(l, SupervisorLog):
            cppLogs.push_back(
                logs_cpp.Logs((<SupervisorLog>l).__impl)
            )
        else:
            raise AttributeError("Unknown log type")
    mail.unistat.cpp.cython.run_cpp.run(host, port, cppLogs, yplatformLogPath, logLevel)
