#include <mail/http_getter/client/include/client.h>

namespace http_getter {

template<class Builder>
auto to(Builder builder, const Endpoint& e) {
    if (e.fallback()) {
        builder.fallback(*e.fallback() + e.method());
    }

    return builder.keepAlive(e.keepAlive())
            .timeouts(e.totalTimeout(), e.connectTimeout())
            .keepAlive(e.keepAlive())
            .maxAttempts(e.tries())
            .logPostArgs(e.logPostBody())
            .logResponseBody(e.logResponseBody());
}

RequestBuilder<Method::Get, false> toGET(const Endpoint& e) {
    return to(get(e.url() + e.method()), e);
}

RequestBuilder<Method::Post, false> toPOST(const Endpoint& e) {
    return to(post(e.url() + e.method()), e);
}

const ErrorCategory& getErrorCategory() {
    static ErrorCategory cat;
    return cat;
}

}
