#pragma once

#include <mail/http_getter/client/include/endpoint.h>
#include <mail/http_getter/client/include/typed_endpoint.h>
#include <yamail/data/reflection/reflection.h>
#include <yamail/data/reflection/details/adt.h>


#define AS_IS(TYPE, NAME)                       (NAME, TYPE, TYPE, obj.NAME, obj.NAME = val)
#define CHANGE_NAME(TYPE, CONF_NAME, NAME)      (CONF_NAME, TYPE, TYPE, obj.NAME, obj.NAME = val)

YREFLECTION_ADAPT_ADT(http_getter::Endpoint::Timeout,
    (connect, long int, long int, obj.connect.count(), obj.connect = std::chrono::milliseconds(val))
    (total, long int, long int, obj.total.count(), obj.total = std::chrono::milliseconds(val))
)

#undef CHANGE_NAME
#undef AS_IS

BOOST_FUSION_ADAPT_STRUCT(http_getter::Endpoint::Data,
    url, fallback, method, tvm_service, keep_alive,
    log_response_body, log_post_body, timeout_ms, tries
)

BOOST_FUSION_ADAPT_STRUCT(http_getter::Endpoint, )
BOOST_FUSION_ADAPT_STRUCT(http_getter::TypedEndpoint, )

#define REFLECT_ENDPOINT_WITH_SET_DATA(NAME) \
    (NAME, const http_getter::Endpoint&, const http_getter::Endpoint&, \
    obj.NAME, obj.NAME.setData(val.data()))

namespace yamail::data::reflection {
    template <typename Visitor>
    struct apply_visitor_impl<http_getter::Endpoint, Visitor> {
        template <typename Tag>
        static void apply(Visitor& v, http_getter::Endpoint& value, Tag&& tag) {
            http_getter::Endpoint::Data raw;
            apply_visitor_default_impl<http_getter::Endpoint::Data>::apply(v, raw, std::forward<Tag>(tag));
            value.setData(std::move(raw));
        }
    };


    template <typename Visitor>
    struct apply_visitor_impl<http_getter::TypedEndpoint, Visitor> {
        template <typename Tag>
        static void apply(Visitor& v, http_getter::TypedEndpoint& value, Tag&& tag) {
            yplatform::ptree tree;
            v.onPtree(tree, std::forward<Tag>(tag));
            value = value.fromPtree(tree);
        }
    };
}
