#pragma once

#include <stdexcept>
#include <mail/http_getter/client/include/fmt.h>

namespace http_getter {

struct Endpoint;

struct EndpointException: public std::runtime_error {
    explicit EndpointException(const std::string& msg, const Endpoint& e);
};

struct TvmException: public std::runtime_error {
    explicit TvmException(const std::string& msg)
        : std::runtime_error(msg)
    { }
};

}
