#pragma once

#include <mail/http_getter/client/include/endpoint.h>
#include <mail/http_getter/client/include/tvm.h>
#include <http_getter/http_request.h>

namespace http_getter::helpers {

inline std::string getUrlByTryNumber(const Endpoint& http, unsigned nTry) {
    if (http.fallback() && nTry != 0) {
        return *http.fallback() + http.method();
    }
    return http.url() + http.method();
}

inline bool successCode(unsigned code) {
    return code / 100 == 2;
}

inline bool retriableCode(unsigned code) {
    return code / 100 == 5;
}

template<class Builder>
void setTickets(Builder& builder, const std::string& tvmService, const TvmManager::TicketsPtr& tickets) {
    if (auto user = tickets->user(tvmService)) {
        builder.headers(userTicket=*user);
    }

    if (auto service = tickets->service(tvmService)) {
        builder.headers(serviceTicket=*service);
    }
}

}
