#pragma once

#include <logdog/logger.h>
#include <logdog/format/tskv.h>
#include <logdog/backend/yplatform_log.h>
#include <logdog/attributes/mail_attributes.h>
#include <mail/http_getter/client/include/request_status.h>


namespace http_getter {

YREFLECTION_DEFINE_ENUM_INLINE(HttpAction,
    starting,
    response_is_got,
    finishing
)

namespace log {

constexpr static auto http_formatter = ::logdog::tskv::make_formatter(BOOST_HANA_STRING("mail-http-log"));

LOGDOG_DEFINE_ATTRIBUTE(std::string_view, operation)
LOGDOG_DEFINE_ATTRIBUTE(HttpAction, action)
LOGDOG_DEFINE_ATTRIBUTE(std::string_view, call_status)
LOGDOG_DEFINE_ATTRIBUTE(RequestStatus, request_status)
LOGDOG_DEFINE_ATTRIBUTE(unsigned, try_n)
LOGDOG_DEFINE_ATTRIBUTE(double, elapsed)
LOGDOG_DEFINE_ATTRIBUTE(unsigned, http_code)
LOGDOG_DEFINE_ATTRIBUTE(std::string, body)
using namespace ::logdog::attr;

}

inline auto getHttpLogger(const std::string& requestId, const std::string& uid, const std::string& logName) {
    auto logger = std::make_shared<yplatform::log::source>(YGLOBAL_LOG_SERVICE, logName);
    auto log = ::logdog::make_log(log::http_formatter, logger);
    return ::logdog::bind(log, log::uid=uid, log::x_request_id=requestId);
}

inline auto getModuleLogger(const std::string& logName) {
    auto logger = std::make_shared<yplatform::log::source>(YGLOBAL_LOG_SERVICE, logName);
    return ::logdog::make_log(log::http_formatter, logger);
}

using Logger = decltype(getHttpLogger("", "", ""));
using ModuleLogger = decltype(getModuleLogger(""));

inline std::string makeHiddenValue(const std::string& value) {
    return std::string("// hidden value with length: ") + std::to_string(value.size()) + " //";
}

}
