#pragma once

#include <mail/http_getter/client/include/logger.h>
#include <mail/http_getter/client/include/request_status.h>

namespace http_getter {

struct RequestStats {
    virtual ~RequestStats() { }

    virtual void starting(const std::string& operation) = 0;

    virtual void responseIsGot(const std::string& operation, unsigned try_n, double elapsed,
                               const std::string& body, unsigned httpCode, Result r) = 0;

    virtual void responseIsGot(const std::string& operation, unsigned try_n, double elapsed,
                               const std::optional<std::string>& body, const std::exception& ex) = 0;

    virtual void responseIsGot(const std::string& operation, unsigned try_n, double elapsed,
                               const std::optional<std::string>& body, const boost::system::error_code& ec) = 0;

    virtual void finishing(const std::string& operation, Result r) = 0;
};

using RequestStatsPtr = std::shared_ptr<RequestStats>;

RequestStatsPtr withLog(Logger logger);


}
