#pragma once

#include <mail/http_getter/client/include/client.h>
#include <ymod_webserver/request.h>

namespace http_getter {

struct ClientModule {
    virtual ~ClientModule() = default;

    virtual Logger httpLogger(const std::string& uid, const std::string& requestId) const = 0;
    virtual ClientPtr create(const ymod_webserver::request& request,
                             RequestStatsPtr stats) const = 0;
    virtual ClientPtr create(const std::string& uniqId,
                             RequestStatsPtr stats) const = 0;
    virtual ClientPtr create(const yplatform::task_context_ptr& ctx, RequestStatsPtr stats) const = 0;

};

using ModulePtr = std::shared_ptr<ClientModule>;

struct TypedClientModule {
    virtual ~TypedClientModule() = default;

    virtual Logger httpLogger(const std::string& uid, const std::string& requestId) const = 0;
    virtual TypedClientPtr create(const ymod_webserver::request& request, RequestStatsPtr stats) const = 0;
    virtual TypedClientPtr create(const std::string& uniqId, RequestStatsPtr stats) const = 0;
    virtual TypedClientPtr create(const yplatform::task_context_ptr& ctx, RequestStatsPtr stats) const = 0;
};

using TypedModulePtr = std::shared_ptr<TypedClientModule>;

}
