#pragma once

#include <mail/http_getter/client/include/exception.h>
#include <mail_errors/error_code.h>
#include <yplatform/spinlock.h>
#include <yplatform/ptree.h>
#include <optional>
#include <atomic>


namespace http_getter {

struct TvmManager {
    struct Option {
        bool service = false;
        bool user = false;
    };

    using Options = std::map<std::string, Option>;
    using OptionsPtr = std::shared_ptr<Options>;
    using TvmTickets = std::map<std::string, std::string>;
    using TvmTicketsPtr = std::shared_ptr<TvmTickets>;

protected:
    mutable yplatform::spinlock lock_;
    const OptionsPtr options_;
    TvmTicketsPtr tickets_;

    TvmTickets& tickets() {
        return *tickets_;
    }

public:
    TvmManager(Options options);

    std::vector<std::string> tvm2ServicesWithServiceTicket() const;
    bool updateTicket(const std::string& service, const std::string& ticket);

    class Tickets {
        std::string user_;
        TvmTicketsPtr serviceTickets_;
        OptionsPtr options_;

        bool enabled(const std::string& service, bool TvmManager::Option::*option) const;
    public:
        Tickets(std::string user, TvmTicketsPtr tickets, OptionsPtr options);

        std::optional<std::string> user(const std::string& service) const;
        std::optional<std::string> service(const std::string& service) const;
    };

    using TicketsPtr = std::shared_ptr<Tickets>;

    TicketsPtr tickets(std::string user) const;
};

TvmManager::Options parseTvmManagerConfig(const yplatform::ptree& node);

using TvmPtr = std::shared_ptr<TvmManager>;

}
