#pragma once

#include <mail/http_getter/client/include/common.h>


namespace http_getter {


namespace detail {

struct RequestBuilderImpl {
    void executor(Executor executor) {
        executor_ = std::move(executor);
    }

    const Executor& executor() const {
        return executor_;
    }

private:
    Executor executor_;
};

}

template <Method method, bool bodyIsSet = false>
struct TypedRequestBuilder : public RequestBuilder<method, bodyIsSet, detail::RequestBuilderImpl> {
    using Base = RequestBuilder<method, bodyIsSet, detail::RequestBuilderImpl >;

    TypedRequestBuilder(Executor executor_, std::string&& urlMethod) 
        : Base(std::move(urlMethod)) {
            this->executor(std::move(executor_));
        }
};


}
