#pragma once

#include <mail/http_getter/client/include/typed_loop.h>


namespace http_getter {

namespace detail {

template<Method m>
inline auto typedTo(const TypedEndpoint& e) {
    return TypedRequestBuilder<m, false>(e.executor(), e.method().data())
                .logResponseBody(e.logResponseBody());
}

}

struct TypedClient {
    http::headers headersToPass_;
    TvmManager::TicketsPtr tickets_;
    RequestStatsPtr lai_;
    TypedRunFactory factory_;

    TypedClient(TvmManager::TicketsPtr tickets, http::headers headersToPass,
                TypedRunFactory factory, RequestStatsPtr stats)
        : headersToPass_(std::move(headersToPass))
        , tickets_(std::move(tickets))
        , lai_(std::move(stats))
        , factory_(std::move(factory))
    { }

    template<class Builder>
    auto pressure(Builder&& b, const std::string& tvm) const {
        if (tickets_) {
            helpers::setTickets(b, tvm, tickets_);
        }
        return b.headers("hdrs"_hdr=headersToPass_);
    }

    template<class Builder>
    auto req(Builder builder) const {
        return std::make_unique<TypedRequestLoop<Builder>>(std::move(builder), factory_, lai_);
    }

    auto toGET(const TypedEndpoint& e) const {
        return pressure(detail::typedTo<Method::Get>(e), e.tvmService());
    }

    auto toHEAD(const TypedEndpoint& e) const {
        return pressure(detail::typedTo<Method::Head>(e), e.tvmService());
    }

    auto toPOST(const TypedEndpoint& e) const {
        return pressure(detail::typedTo<Method::Post>(e), e.tvmService());
    }

    auto toPUT(const TypedEndpoint& e) const {
        return pressure(detail::typedTo<Method::Put>(e), e.tvmService());
    }

    auto toDELETE(const TypedEndpoint& e) const {
        return pressure(detail::typedTo<Method::Delete>(e), e.tvmService());
    }

};

using TypedClientPtr = std::shared_ptr<TypedClient>;

}
