#pragma once

#include <mail/http_getter/client/include/common.h>

namespace http_getter {

class TypedEndpoint {
public:
    TypedEndpoint() = default;

    template<class ... Args>
    TypedEndpoint format(const Args&... args) const {
        TypedEndpoint res{*this};
        res.method_ = fmt::format(res.method_, args...);
        return res;
    }

    const std::string& method() const {
        return method_;
    }

    const std::string& tvmService() const {
        return tvmService_;
    }

    bool logResponseBody() const {
        return logResponseBody_;
    }

    const Executor& executor() const {
        return executor_;
    }

    static TypedEndpoint fromPtree(const yplatform::ptree& conf) {
        TypedEndpoint res;
        res.parsePtree(conf);
        return res;
    }

    static TypedEndpoint fromData(std::string method, std::string tvmService, Executor executor) {
        TypedEndpoint res;
        res.method_ = std::move(method);
        res.tvmService_ = std::move(tvmService);
        res.executor_ = std::move(executor);
        return res;
    }

private:

    std::string method_;
    std::string tvmService_;
    bool logResponseBody_ = false;
    Executor executor_;

    void parsePtree(const yplatform::ptree& conf) {
        method_ = conf.get("method", method_);
        tvmService_ = conf.get("tvm_service", tvmService_);
        logResponseBody_ = conf.get("log_response_body", logResponseBody_);

        const auto& clientConf = conf.get_child("client");

        executor_ = std::make_shared<TypedHttpClient>(
            yplatform::find_reactor(clientConf.get<std::string>("reactor")),
            TypedHttpClient::settings::from_ptree(clientConf)
        );
    }
};


}
