#pragma once

#include <mail/http_getter/client/include/common.h>
#include <mail/http_getter/client/include/metrics.h>
#include <mail/http_getter/client/include/typed_builder.h>
#include <mail/http_getter/client/include/typed_endpoint.h>
#include <mail/http_getter/client/include/tvm.h>
#include <mail/http_getter/client/include/helpers.h>
#include <io_result/io_result.h>

namespace http_getter {

template<class Builder>
struct TypedRequestLoop {
    TypedRequestLoop(Builder builder, TypedRunFactory factory, RequestStatsPtr lai)
        : builder_(std::move(builder))
        , factory_(std::move(factory))
        , lai_(std::move(lai))
    { }

    template<class H, class Operation>
    void backgroundCall(Operation operation, H handler) {
        makeAsyncCall(operation, adapted(std::move(handler)), io_result::use_future);
    }

    template<class Operation, class H, class Context = io_result::sync_context>
    auto call(Operation operation, H handler, Context ctx = io_result::use_sync) {
        return makeAsyncCall(operation, adapted(std::move(handler)), ctx);
    }

    template<class Operation, class Context>
    auto makeAsyncCall(Operation operation, Handler handler, Context ctx) {
        io_result::detail::init_async_result<Context, io_result::Hook<void>> init{ctx};

        std::string operationName = (lai_) ? getOperationName(operation) : "";
        TypedRun run = factory_(builder_.executor(), lai_, std::move(operationName));
        run(std::move(builder_).make(), std::move(handler), init.handler);

        return init.result.get();
    }

    Builder builder_;
    TypedRunFactory factory_;
    RequestStatsPtr lai_;
};

}
