#include <mail/http_getter/client/include/metrics.h>

namespace http_getter {

namespace {
std::string emptyBody() {
    return "std::nullopt";
}
}

struct LogRequestStats: public RequestStats {
    Logger logger_;

    LogRequestStats(Logger logger)
        : logger_(std::move(logger))
    { }

    virtual ~LogRequestStats() { }

    void starting(const std::string& operation) override {
        LOGDOG_(logger_, notice, log::operation=operation,
                log::action=HttpAction::starting);
    }

    void responseIsGot(const std::string& operation, unsigned try_n, double elapsed,
                       const std::string& body, unsigned httpCode, Result r) override {
        LOGDOG_(logger_, notice, log::operation=operation,
                log::action=HttpAction::response_is_got, log::try_n=try_n,
                log::elapsed=elapsed, log::body=body, log::http_code=httpCode,
                log::call_status=yamail::data::reflection::to_string(r));
    }

    void responseIsGot(const std::string& operation, unsigned try_n, double elapsed,
                       const std::optional<std::string>& body, const std::exception& ex) override {
        LOGDOG_(logger_, notice, log::operation=operation,
                log::action=HttpAction::response_is_got, log::try_n=try_n,
                log::elapsed=elapsed, log::body=body.value_or(emptyBody()), log::exception=ex,
                log::call_status=yamail::data::reflection::to_string(Result::retry));
    }

    void responseIsGot(const std::string& operation, unsigned try_n, double elapsed,
                       const std::optional<std::string>& body, const boost::system::error_code& ec) override {
        LOGDOG_(logger_, notice, log::operation=operation,
                log::action=HttpAction::response_is_got, log::try_n=try_n,
                log::elapsed=elapsed, log::body=body.value_or(emptyBody()), log::error_code=ec,
                log::call_status=yamail::data::reflection::to_string(Result::retry));
    }

    void finishing(const std::string& operation, Result r) override {
        RequestStatus status;
        switch(r) {
            case Result::success: status = RequestStatus::success;   break;
            case Result::fail:    status = RequestStatus::fail;      break;
            case Result::retry:   status = RequestStatus::try_limit; break;
        }

        LOGDOG_(logger_, notice, log::operation=operation,
                log::action=HttpAction::finishing, log::request_status=status);
    }
};

RequestStatsPtr withLog(Logger logger) {
    return std::make_shared<LogRequestStats>(std::move(logger));
}

}
