#pragma once

#include "options.h"
#include <ymod_httpclient/call.h>
#include <yplatform/task_context.h>
#include <functional>

namespace http_getter::detail {

using TaskContextPtr = boost::shared_ptr<yplatform::task_context>;
using CallbackType = std::function<void(const boost::system::error_code&, yhttp::response)>;
using HttpClient = ymod_httpclient::simple_call;
using ClusterClient = ymod_httpclient::cluster_call;


using TypedHttpClient = yhttp::typed_client<yhttp::response>;
using TypedHttpClientPtr = std::shared_ptr<TypedHttpClient>;

template <typename Client, typename CompletionToken>
auto asyncRun(Client& client, const TaskContextPtr context, const Request& request, CompletionToken&& token) {
    return client.async_run(context, request.request, toClientOptions<Client>(request.options), std::forward<CompletionToken>(token));
}

template <typename Client>
auto asyncRun(Client& client, const TaskContextPtr context, const Request& request, CallbackType callback) {
    return client.async_run(context, request.request, toClientOptions<Client>(request.options), callback);
}

template <typename HandlerAndToken>
auto asyncRun(TypedHttpClient& client, const TaskContextPtr context, const Request& request, HandlerAndToken ht) {
    return client.async_run(context, request.request, toClientOptions<TypedHttpClient>(request.options), ht, ht);
}

} // namespace http_getter::detail
