#pragma once

#include <ymod_httpclient/call.h>
#include <ymod_httpclient/typed_client.h>
#include <boost/optional.hpp>

namespace http_getter::detail {

struct Options {
    std::optional<bool> logPostArgs;
    std::optional<bool> logHeaders;
    std::optional<bool> keepAlive;
    ymod_httpclient::timeouts timeouts;
    std::optional<unsigned> maxAttempts;
    std::optional<bool> logResponseBody;
};

namespace {
template<typename T>
boost::optional<T> optionalCast(const std::optional<T>& opt) {
    return opt.has_value() ? boost::make_optional(opt.value()) : boost::none;
}
} // namespace

template<typename Client>
inline decltype(auto) toClientOptions(const Options&);

template<>
inline decltype(auto) toClientOptions<ymod_httpclient::simple_call>(const Options& options) {
    return yhttp::options{
        optionalCast(options.logPostArgs),
        optionalCast(options.logHeaders),
        optionalCast(options.keepAlive),
        options.timeouts
    };
}

template<>
inline decltype(auto) toClientOptions<ymod_httpclient::cluster_call>(const Options& options) {
    return ymod_httpclient::cluster_call::options{
        toClientOptions<ymod_httpclient::simple_call>(options),
        optionalCast(options.maxAttempts)
    };
}

template<>
inline decltype(auto) toClientOptions<yhttp::typed_client<yhttp::response>>(const Options& options) {
    return toClientOptions<ymod_httpclient::cluster_call>(options);
}

} // namespace http_getter::detail
