from collections import namedtuple

from mail.pypg.pypg.query_conf import load_from_package
from mail.pypg.pypg.query_handler import (
    QueryHandler,
    FetchHeadExpectOneRowAs,
    FetchAs,
)

CloneAudit = namedtuple(
    'CloneAudit',
    ('source_uid', 'dest_uid', 'transfer_id',
     'request_info', 'complete', 'complete_at')
)

TaskInfo = namedtuple(
    'TaskInfo',
    ('transfer_id',
     'uid', 'task', 'task_args',
     'status', 'error_type', 'try_notices',
     'tries', 'last_update', 'priority')
)

ShardInfo = namedtuple(
    'ShardInfo',
    ('shard_id', 'can_transfer_to')
)


def fetch_inserted_count(cur):
    return cur.rowcount


def fetch_nothing(_):
    pass


def fetch_head_with_one_attribute(cur):
    row = cur.fetchone()
    assert row is not None, \
        'Expect at least one row got nothing'
    return row[0]


class ApiQueries(QueryHandler):
    q = load_from_package(__package__, __file__)
    handlers = dict(
        get_clone_audit=(
            q.get_clone_audit, FetchHeadExpectOneRowAs(CloneAudit)),
        add_clone_audit=(q.add_clone_audit, fetch_nothing),
        mark_clone_audit_as_completed=(
            q.mark_clone_audit_as_completed, fetch_nothing),
        add_task=(q.add_task, FetchHeadExpectOneRowAs(TaskInfo)),
        get_task=(q.get_task, FetchHeadExpectOneRowAs(TaskInfo)),
        get_task_by_user_and_type=(q.get_task_by_user_and_type, FetchAs(TaskInfo)),
        get_shiva_shard=(q.get_shiva_shard, FetchAs(ShardInfo)),
        add_task_for_users=(q.add_task_for_users, fetch_inserted_count),
    )
