
-- name: get_clone_audit
SELECT source_uid, dest_uid,
       transfer_id, request_info,
       complete, complete_at
  FROM transfer.clone_user_audit
 WHERE source_uid = :source_uid
   AND dest_uid = :dest_uid

-- name: add_clone_audit
INSERT INTO transfer.clone_user_audit
    (source_uid, dest_uid,
    transfer_id, request_info)
VALUES
    (:source_uid, :dest_uid,
    :transfer_id, :request_info::jsonb)

-- name: mark_clone_audit_as_completed
UPDATE transfer.clone_user_audit
   SET complete = TRUE,
       complete_at = current_timestamp
 WHERE source_uid = :source_uid
   AND dest_uid = :dest_uid

-- name: add_task
INSERT INTO transfer.users_in_dogsleds
    (uid, task, task_args,
     shard_id, status, priority)
VALUES
    (:uid, :task, :task_args,
     :shard_id, :status, :priority)
RETURNING
       transfer_id, uid, task, task_args,
       status, error_type, try_notices,
       tries, last_update, priority

-- name: add_task_for_users
INSERT INTO transfer.users_in_dogsleds
    (uid, task, task_args, shard_id, priority)
VALUES
    (UNNEST(:uids), :task, :task_args, :shard_id, :priority)
ON CONFLICT DO NOTHING

-- name: get_task
SELECT transfer_id, uid, task, task_args,
       status, error_type, try_notices,
       tries, last_update, priority
  FROM transfer.users_in_dogsleds
 WHERE transfer_id = :transfer_id
UNION
SELECT transfer_id, uid, task, task_args,
       status, error_type, try_notices,
       tries, last_update, priority
  FROM transfer.processed_tasks
 WHERE transfer_id = :transfer_id

-- name: get_task_by_user_and_type
SELECT transfer_id, uid, task, task_args,
       status, error_type, try_notices,
       tries, last_update, priority
  FROM transfer.users_in_dogsleds
 WHERE uid = :uid AND task = :task

-- name: get_shiva_shard
SELECT shard_id, can_transfer_to
  FROM shiva.shards
 WHERE shard_id = :shard_id
