-- name: move_user_to_deleted
SELECT code.move_user_to_deleted(:uid)

-- name: users_by_shard
SELECT uid
  FROM shards.users AS u
  JOIN shards.shards AS s
 USING (shard_id)
 WHERE s.name = :shard_name
   AND uid > :last_uid
 ORDER BY uid
 LIMIT :chunk_size

-- name: deleted_users_by_shard
SELECT uid
  FROM shards.deleted_users AS du
  JOIN shards.shards AS s
 USING (shard_id)
 WHERE s.name = :shard_name
   AND uid > :last_uid
 ORDER BY uid
 LIMIT :chunk_size
