# coding: utf-8

import logging

from psycopg2 import ProgrammingError
from psycopg2.errorcodes import UNDEFINED_FUNCTION
from mail.pypg.pypg.common import transaction

from mail.husky.husky.types import Task, ResultData, Errors
from ora2pg.sharpei import get_pg_dsn_from_sharpei
from pymdb import operations as OPS
from .base import BaseTask

log = logging.getLogger(__name__)


class ApplyDataMigrations(BaseTask):
    name = Task.ApplyDataMigrations

    def run(self):
        target_data_version = self.task_args.get('target_data_version')
        maildb_dsn = get_pg_dsn_from_sharpei(
            self.config.sharpei,
            self.uid,
            self.config.maildb_dsn_suffix
        )
        with transaction(maildb_dsn) as conn:
            applier = OPS.ApplyDataMigrations(conn, self.uid)
            try:
                applier(target_data_version)
            except ProgrammingError as e:
                if e.pgcode == UNDEFINED_FUNCTION:
                    log.exception(e)
                    return ResultData(
                        transfer_id=self.transfer_id,
                        error=Errors.WrongArgs,
                        error_message=repr(e),
                        task_output=None,
                    )
                raise e
