from mail.pypg.pypg import common as pg
from mail.pypg.pypg.query_conf import load_from_package
from ora2pg import sharpei
from mail.husky.husky.types import Task
from .base import BaseTask

QUERIES = load_from_package(__package__, __file__)


class CutFirstlines(BaseTask):
    name = Task.CutFirstlines
    required_args = ['target_length']

    @property
    def target_length(self):
        return self.task_args['target_length']

    @property
    def max_received_date(self):
        return self.task_args.get('max_received_date', None)

    def run(self):
        user_dsn = sharpei.get_pg_dsn_from_sharpei(
            sharpei=self.config.sharpei,
            uid=self.uid,
            dsn_suffix=self.config.maildb_dsn_suffix
        )

        with pg.transaction(dsn=user_dsn) as conn:
            pg.qexec(
                conn,
                QUERIES.cut_letters,
                uid=self.uid,
                target_length=self.target_length,
                max_received_date=self.max_received_date,
            )
