-- name: cut_letters
with old_fl as (
    SELECT mid,
           firstline
    FROM mail.box JOIN mail.messages USING (uid, mid)
    WHERE uid = :uid
      AND received_date <= COALESCE(:max_received_date, now())
      AND length(firstline) > :target_length + 20
    UNION ALL
    SELECT mid, firstline
    FROM mail.deleted_box JOIN mail.messages USING (uid, mid)
    WHERE uid = :uid
      AND (deleted_box.info->>'received_date')::timestamp with time zone <= COALESCE(:max_received_date, now())
      AND length(firstline) > :target_length + 20
)
UPDATE mail.messages msgs
SET firstline = substr(
   msgs.firstline,
   0,
   :target_length + least(20, position(' ' in substr(msgs.firstline || ' ', :target_length)) - 1)
)
FROM old_fl
WHERE uid = :uid
AND msgs.mid = old_fl.mid
