from mail.husky.husky.sharddb import SharddbAdaptor, ShardIdResolveException
from mail.husky.husky.tasks.errors import MalformedArgumentError
from ora2pg.transfer_data import DbEndpoint


class ShardResolverMixin(object):
    def _get_sharddb_adaptor(self):
        if not hasattr(self, '_sharddb_adaptor'):
            self._sharddb_adaptor = SharddbAdaptor(self.app.args)
        return self._sharddb_adaptor

    def resolve_endpoint(self, db):
        if not isinstance(db, DbEndpoint):
            db = DbEndpoint(db)
        try:
            return self._get_sharddb_adaptor().resolve_endpoint(db)
        except ShardIdResolveException as e:
            raise MalformedArgumentError(e)
