from collections import namedtuple

from mail.pypg.pypg.query_conf import load_from_package
from mail.pypg.pypg.query_handler import (
    QueryHandler,
    FetchHeadExpectOneRowAs
)


GlobalArgs = namedtuple(
    'GlobalArgs',
    ('args_id', 'task_args')
)


QUERIES = load_from_package(__package__, __file__)


class TaskQueries(QueryHandler):
    handlers = dict(
        get_global_args=(
            QUERIES.get_global_args, FetchHeadExpectOneRowAs(GlobalArgs))
    )
