# coding: utf-8

from collections import namedtuple
from datetime import datetime  # noqa
from typing import Dict, Optional  # noqa

UserData = namedtuple(
    'UserData',
    ('transfer_id', 'uid', 'task', 'task_args')
)


class Task(object):
    ApplyDataMigrations = 'apply_data_migrations'
    CloneUser = 'clone_user'
    CutFirstlines = 'cut_firstlines'
    DeleteMailUser = 'delete_mail_user'
    DeleteShardsUser = 'delete_shards_user'
    PutLetter = 'put_letter'
    Transfer = 'transfer'
    TransferFromBackup = 'transfer_from_backup'
    TransferMarketCrm = 'transfer_market_crm'
    MoveMessagesToTabs = 'move_messages_to_tabs'
    UnlabelMessages = 'unlabel_messages'


class Status(object):
    Pending = 'pending'
    InProgress = 'in_progress'
    Complete = 'complete'
    Error = 'error'


ErrorType = namedtuple(
    'ErrorType',
    ('name', 'is_retriable')
)


class Errors(object):
    NoError = ErrorType(None, False)
    InvalidFromDb = ErrorType('transfer_invalid_from_db', False)
    WrongArgs = ErrorType('wrong_args', False)
    NotSupported = ErrorType('not_supported', False)
    NoSuchUser = ErrorType('no_such_user', False)
    ClosedShard = ErrorType('closed_dest_shard', False)
    Unknown = ErrorType('unknown', True)
    FailedGetData = ErrorType('failed_get_data', False)
    FailedWriteData = ErrorType('failed_write_data', False)
    DeferredDueToMessageCountLimit = ErrorType('deferred_due_to_message_count_limit', False)
    UserBlocked = ErrorType('user_blocked', False)


class ResultData(
        namedtuple('ResultData',
                   ['transfer_id', 'error', 'error_message', 'task_output'])
):
    __slots__ = ()

    def __new__(
        cls,
        transfer_id,        # type: int
        error,              # type: ErrorType
        error_message,      # type: Optional[str]
        task_output=None,   # type: Optional[Dict]
    ):
        return super(ResultData, cls).__new__(
            cls,
            transfer_id,
            error,
            error_message,
            task_output,
        )
