# coding: utf-8

import json
from datetime import datetime
from functools import wraps

from werkzeug.wrappers import Response


class DateTimeEncoder(json.JSONEncoder):
    def default(self, obj):
        if isinstance(obj, datetime):
            return obj.isoformat()
        return json.JSONEncoder.default(self, obj)


def jdumps(obj):
    return json.dumps(obj, cls=DateTimeEncoder)


def make_json_response(obj):
    return Response(jdumps(obj).encode('utf-8'), mimetype='application/json')


def json_response(func):
    @wraps(func)
    def deco(*args, **kwargs):
        obj = func(*args, **kwargs)
        return make_json_response(obj)
    return deco
