#!/bin/bash

# make 10 attemps in case of any problems
for i in {1..10}; do
    if [[ -d /ephemeral ]]; then
        mkdir -p /ephemeral/var/log/
        rsync -av /var/log/ /ephemeral/var/log/

        rm -rf /var/log

        ln -sf /ephemeral/var/log /var/log

        break
    else
        echo "Ephemeral not found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "[ERROR] Failed to link ephemeral, cannot start"
    exit 1
fi


if [[ -z "${APPLICATION_NAME}" ]]; then
    if [[ -z "${QLOUD_COMPONENT}" ]] ; then
        echo "[ERROR] Either APPLICATION_NAME or QLOUD_COMPONENT env var must be set"
        exit 1
    fi
    APPLICATION_NAME="${QLOUD_COMPONENT}"
fi

if [[ -z "${ENV_QLOUD_ENVIRONMENT}" ]]; then
    echo "[ERROR] ENV_QLOUD_ENVIRONMENT env var must be set"
    exit 1
fi

ln -sf /tvm2_root_client_id-${ENV_QLOUD_ENVIRONMENT} /tvm2_root_client_id

chmod 644 /etc/logrotate.d/*
chmod 644 /etc/cron.d/*
