-- Huskydb queries

-- name: process_in_progress
    UPDATE transfer.users_in_dogsleds u
       SET status = CASE
           WHEN tries + 1 >= (:max_tries::jsonb->>(task::text))::smallint THEN
               'error'::transfer.task_status
           ELSE
               :status::transfer.task_status
           END,
           tries = tries + 1,
           try_notices = array_append(
               try_notices,
               'Moved from in_progress at ' || last_update
            ),
           last_update = now()
     WHERE shard_id = :shard_id
       AND (:husky_cluster = :default_cluster AND COALESCE(task_group_id, -1) = -1
                OR COALESCE(task_group_id, -1) in (SELECT id FROM transfer.task_group WHERE husky_cluster = :husky_cluster))
       AND status = 'in_progress'
 RETURNING u.transfer_id

-- name: acquire_tasks
    UPDATE transfer.users_in_dogsleds u
       SET status = 'in_progress',
           last_update = current_timestamp
      FROM (
        SELECT transfer_id
          FROM transfer.users_in_dogsleds new
         WHERE new.status = 'pending'
           AND new.shard_id = :shard_id
           AND new.planned <= current_timestamp
           AND (:husky_cluster = :default_cluster AND COALESCE(new.task_group_id, -1) = -1
                OR COALESCE(new.task_group_id, -1) in (SELECT id FROM transfer.task_group WHERE husky_cluster = :husky_cluster)
           )
           AND NOT EXISTS (
            SELECT 1
              FROM transfer.users_in_dogsleds dep
             WHERE dep.uid = new.uid
               AND (
                       dep.status = 'in_progress'
                    OR (
                           code.task_is_queued(dep.status)
                       AND code.is_blocker_of(dep.task, new.task)
                    )
                )
           )
           AND (
            new.task != 'transfer'
            OR
            NOT EXISTS (
            SELECT 1
              FROM transfer.stoplist slist
             WHERE new.uid = slist.uid
           )
        )
      ORDER BY priority, planned
         LIMIT :usercount
     ) s
     WHERE u.transfer_id = s.transfer_id
 RETURNING u.transfer_id, u.uid, u.task, u.task_args

-- name: complete_task
WITH deleted_tasks AS (
    DELETE FROM transfer.users_in_dogsleds
     WHERE transfer_id = :transfer_id
 RETURNING *
)
INSERT INTO transfer.processed_tasks
       (transfer_id, uid, priority, tries, task, task_args, try_notices,
       shard_id, status, planned, last_update, error_type, task_output)
SELECT transfer_id, uid, priority, tries, task, task_args, try_notices,
       shard_id, 'complete', planned, current_timestamp, NULL, :task_output::jsonb
  FROM deleted_tasks
RETURNING status, tries

-- name: retry_task
UPDATE transfer.users_in_dogsleds
   SET tries = tries + 1,
       status = 'pending',
       planned = current_timestamp + :delay,
       last_update = current_timestamp,
       error_type = NULL,
       try_notices = array_append(try_notices, :error_message),
       task_output = :task_output::jsonb
 WHERE transfer_id = :transfer_id
RETURNING status, tries

-- name: fail_task
UPDATE transfer.users_in_dogsleds
   SET tries = tries + 1,
       status = 'error',
       last_update = current_timestamp,
       error_type = :error_type::transfer.error,
       try_notices = array_append(try_notices, :error_message),
       task_output = :task_output::jsonb
 WHERE transfer_id = :transfer_id
RETURNING status, tries

-- name: get_task_info
SELECT task, tries
  FROM transfer.users_in_dogsleds
 WHERE transfer_id = :transfer_id

-- name: get_cluster_id_by_shard_id
SELECT cluster_id
  FROM shiva.shards
 WHERE shard_id = :shard_id

-- name: get_max_workers_by_shard_id
SELECT max_workers
  FROM buckets.workload
 WHERE shard_id = :shard_id
